////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  ASHTTPConnection.h
//
//  Copyright 2009-2012 Acclivity Group LLC, all rights reserved.
//
//  Change History (most recent first):
//
//  04/30/12  K.L.S.  Modified http code for updated API.
//	03/04/09  K.L.S.  Created File.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "CrossPlatform/CrossPlatform.h"
#include "ASFoundation/ASObject.h"

namespace ASFoundation
{
	class EXTERNAL_API ASHTTPConnection : public ASObject
	{
	public:
		static ASHTTPConnection* Create(void);
		static CPString PostHTTPMethod(void);
		static CPString PutHTTPMethod(void);
		static CPString GetHTTPMethod(void);
		static CPString DeleteHTTPMethod(void);
		static CPString UserAgentHTTPHeader(void);

		virtual ~ASHTTPConnection(void);

		bool IsSecured(void) const;
		void SetIsSecured(bool IsSecured);

		virtual unsigned long TimeoutInSeconds(void) const;
		virtual void SetTimeoutInSeconds(unsigned long TimeoutIntervalInSeconds);

		CPString HTTPMethod(void) const;
		void SetHTTPMethod(const CPString& HttpMethod);

		CPString URL(void) const;
		void SetURL(const CPString& Url);
		void AddValueForURLParameter(const CPString& ParameterValue, const CPString& URLParameter);
		CPDictionary URLParameters(void) const;
		void AddValueForHTTPHeader(const CPString& HeaderValue, const CPString& HeaderField);
		CPDictionary HTTPHeaders(void) const;
		CPString HTTPHeadersAsString(void) const;
		CPData Body(void) const;
		void SetBody(const CPData& Body);

		//TODO: KLS - look to remove this functionality
		bool ShouldEncodeURL(void) const;
		void SetShouldEncodeURL(bool ShouldEncodeURL);


		virtual CPData SendSynchronousRequest(void) = 0;
		virtual CPData SendAsynchronousRequest(void) = 0;

#if _WINDOWS
		void SetUseCertificate(const CPString& CertificateFilePath, const CPString& CertificatePassword);
#endif

		// NSURLSession
#if __OBJC__
		virtual void SetClientCertificateArray(const CPArray& ClientCertificateArray) = 0;
		virtual void SetServerCertificateName(const CPString& ServerCertificateName) = 0;
		virtual void SetServerCertificatePinningData(const CPString& ServerCertificatePinningData) = 0;
		inline CPInteger ResponseStatusCode(void) { return m_ResponseStatusCode; }
		inline CPDictionary ResponseHeaders(void) { return m_ResponseHeaders; }
		inline void UseNSURLSession(bool UseNSURLSession) { m_UseNSURLSession = UseNSURLSession; }
#else
		// Do nothing on Windows
		inline void UseNSURLSession(bool /*UseNSURLSession*/) {}
#endif

	protected:
		CPString URLParametersAsString(void) const;

		unsigned long m_TimeoutIntervalInSeconds;
		bool m_IsSecured;
		//  Pull this out later - client should do encoding - time constraint now
		bool m_ShouldEncodeURL;
		CPString m_HttpMethod;
		CPString m_Url;
		CPData m_Body;
		CPMutableDictionary m_URLParameters;
		CPMutableDictionary m_HTTPHeaders;

#if _WINDOWS
		bool m_UseCertificate;
		CPString m_CertificateFilePath;
		CPString m_CertificatePassword;
#endif

		// NSURLSession
#if __OBJC__
		bool m_UseNSURLSession;
		CPInteger m_ResponseStatusCode;
		CPDictionary m_ResponseHeaders;
#endif

		ASHTTPConnection(void);
	};
}
